/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm8260.DecoderException;
import ibm.nways.jdm8260.MibInfo;
import ibm.nways.jdm8260.MibValue;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.lang.reflect.Field;

public final class MstDecoder {
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final Integer INT_TYPE = new Integer(0);
    private static final int INTEGER_TYPE = 0;
    private static final Integer STR_TYPE = new Integer(1);
    private static final int STRING_TYPE = 1;
    private static final Integer IP_TYPE = new Integer(2);
    private static final int IPADDR_TYPE = 2;
    private static final Integer MAC_TYPE = new Integer(3);
    private static final int MACADDR_TYPE = 3;
    private byte[] values;
    private static int numberOfIndexes;
    private MibInfo mibInfo;
    private static final Object[][] genericModuleInformation;
    private static final Object[][] genericPortInformation;
    private static final Object[][] genericTrunkInformation;
    private static final int specificModuleT44Indexes = 2;
    private static final Object[][] specificModuleT44Information;
    private static final int specificModuleT45Indexes = 2;
    private static final Object[][] specificModuleT45Information;
    private static final int specificModuleT49Indexes = 2;
    private static final Object[][] specificModuleT49Information;
    private static final int specificModuleT63Indexes = 1;
    private static final Object[][] specificModuleT63Information;
    private static final int specificPortT63Indexes = 2;
    private static final Object[][] specificPortT63Information;
    private static final int specificModuleT64Indexes = 1;
    private static final Object[][] specificModuleT64Information;
    private static final int specificPortT64Indexes = 2;
    private static final Object[][] specificPortT64Information;
    private static final int specificModuleT73Indexes = 2;
    private static final Object[][] specificModuleT73Information;
    private static final int specificPortT73Indexes = 2;
    private static final Object[][] specificPortT73Information;
    private static final int specificModuleT97Indexes = 2;
    private static final Object[][] specificModuleT97Information;
    private static final int specificPortT97Indexes = 3;
    private static final Object[][] specificPortT97Information;
    private static final int specificModuleT123Indexes = 2;
    private static final Object[][] specificModuleT123Information;
    private static final int specificPortT123Indexes = 2;
    private static final Object[][] specificPortT123Information;
    private static final int specificModuleT138Indexes = 2;
    private static final Object[][] specificModuleT138Information;
    private static final int specificPortT138Indexes = 2;
    private static final Object[][] specificPortT138Information;
    private static final int specificModuleT153Indexes = 2;
    private static final Object[][] specificModuleT153Information;
    private static final int specificPortT153Indexes = 2;
    private static final Object[][] specificPortT153Information;
    private static final int specificModuleT164Indexes = 2;
    private static final Object[][] specificModuleT164Information;
    private static final int specificPortT164Indexes = 2;
    private static final Object[][] specificPortT164Information;

    protected void finalize() throws Throwable {
        this.values = null;
        this.mibInfo = null;
    }

    public final void setMibInfo(MibInfo mibInfo) {
        this.mibInfo = mibInfo;
    }

    private final int decodeInformation(int n, int n2, String string, Object[][] objectArray) throws DecoderException {
        String string2 = "decodeInformation";
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            String string3 = (String)objectArray[n4][0];
            String string4 = (String)objectArray[n4][1];
            int n5 = (Integer)objectArray[n4][2];
            switch (n5) {
                case 0: {
                    int n6 = this.values[n++] & 0xFF;
                    ++n3;
                    this.mibInfo.addVar(string4, new MibValue(string, new Integer(n6)));
                    if (!RAS.isEnabled(19, 28)) break;
                    RAS.trace(19, 28, this, string2, String.valueOf(string3) + " -> " + n6);
                    break;
                }
                case 1: {
                    int n7;
                    String string5 = "";
                    while (n3 < n2) {
                        n7 = this.values[n++] & 0xFF;
                        ++n3;
                        if (n7 == 0) break;
                        string5 = String.valueOf(string5) + (char)n7;
                    }
                    this.mibInfo.addVar(string4, new MibValue(string, (Serializable)((Object)new String(string5))));
                    if (!RAS.isEnabled(19, 28)) break;
                    RAS.trace(19, 28, this, string2, String.valueOf(string3) + " -> " + string5);
                    break;
                }
                case 2: {
                    int n7 = 0;
                    int n8 = 0;
                    while (n8 < 4) {
                        n7 = n7 << 8 | this.values[n++] & 0xFF;
                        ++n3;
                        ++n8;
                    }
                    IPAddress iPAddress = new IPAddress(n7);
                    this.mibInfo.addVar(string4, new MibValue(string, iPAddress));
                    if (!RAS.isEnabled(19, 28)) break;
                    RAS.trace(19, 28, this, string2, String.valueOf(string3) + " -> " + iPAddress);
                    break;
                }
                case 3: {
                    byte[] byArray = new byte[6];
                    int n9 = 0;
                    while (n9 < 6) {
                        byArray[n9] = this.values[n++];
                        ++n3;
                        ++n9;
                    }
                    OctetString octetString = new OctetString(byArray);
                    this.mibInfo.addVar(string4, new MibValue(string, octetString));
                    if (!RAS.isEnabled(19, 28)) break;
                    RAS.trace(19, 28, this, string2, String.valueOf(string3) + " -> " + octetString);
                    break;
                }
                default: {
                    throw new DecoderException("Unknown decoder type " + n5 + "for metainformation " + objectArray[n4]);
                }
            }
            ++n4;
        }
        return n3;
    }

    private final Object[][] getSpecificModuleMetaInfo(int n) {
        String string = "getSpecificModuleMetaInfo";
        if (n != -1) {
            try {
                Class<?> clazz = this.getClass();
                String string2 = "specificModuleT" + n + "Indexes";
                Field field = clazz.getDeclaredField(string2);
                numberOfIndexes = field.getInt(null);
                if (RAS.isEnabled(19, 28)) {
                    RAS.trace(19, 28, this, string, "Found specific module information for modType -> " + n);
                }
                String string3 = "specificModuleT" + n + "Information";
                Field field2 = clazz.getDeclaredField(string3);
                return (Object[][])field2.get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (Exception exception) {
                RAS.logException(19, 28, this, string, exception);
            }
        }
        return null;
    }

    private final Object[][] getSpecificPortMetaInfo(int n) {
        String string = "getSpecificPortMetaInfo";
        if (n != -1) {
            try {
                Class<?> clazz = this.getClass();
                String string2 = "specificPortT" + n + "Indexes";
                Field field = clazz.getDeclaredField(string2);
                numberOfIndexes = field.getInt(null);
                if (RAS.isEnabled(19, 28)) {
                    RAS.trace(19, 28, this, string, "Found specific port information for modType -> " + n);
                }
                String string3 = "specificPortT" + n + "Information";
                Field field2 = clazz.getDeclaredField(string3);
                return (Object[][])field2.get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private final Object[][] getSpecificTrunkMetaInfo(int n) {
        String string = "getSpecificTrunkMetaInfo";
        if (n != -1) {
            try {
                Class<?> clazz = this.getClass();
                String string2 = "specificTrunkT" + n + "Indexes";
                Field field = clazz.getDeclaredField(string2);
                numberOfIndexes = field.getInt(null);
                if (RAS.isEnabled(19, 28)) {
                    RAS.trace(19, 28, this, string, "Found specific trunk information for modType -> " + n);
                }
                String string3 = "specificTrunkT" + n + "Information";
                Field field2 = clazz.getDeclaredField(string3);
                return (Object[][])field2.get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private final void decodeV1Entry(int n, int n2, int n3) throws DecoderException {
        String string;
        int n4;
        String string2 = "decodeV1Entry";
        if ((n4 = this.values[n++] & 0xFF) != 1) {
            throw new DecoderException("Structure version mismatch. Expected version 1 entry and found version " + n4 + " at pos. " + (n - 1));
        }
        int n5 = this.values[n++] & 0xFF;
        int n6 = this.values[n++] & 0xFF;
        int n7 = this.values[n++] & 0xFF;
        int n8 = this.values[n++] & 0xFF;
        int n9 = this.values[n++] & 0xFF;
        int n10 = this.values[n++] & 0xFF;
        if (RAS.isEnabled(19, 28)) {
            RAS.trace(19, 28, this, string2, "----- MODULE INFORMATION -----");
            RAS.trace(19, 28, this, string2, "modSlotIndex -> " + n2);
            RAS.trace(19, 28, this, string2, "modSubSlotIndex -> " + n3);
        }
        String string3 = "." + n2 + "." + n3;
        int n11 = 0;
        n11 = this.decodeInformation(n, n5, string3, genericModuleInformation);
        if (n11 < n5 && RAS.isEnabled(19, 28)) {
            RAS.trace(19, 28, this, string2, "Some information was not decoded in the generic module information. Missing " + (n5 - n11) + " bytes.");
        }
        n += n5;
        int n12 = -1;
        int n13 = 0;
        int n14 = 0;
        Serializable serializable = this.mibInfo.getVar("ocModType", string3);
        if (serializable instanceof MibValue) {
            n12 = ((MibValue)serializable).getIntValue();
        }
        if ((serializable = this.mibInfo.getVar("ocModNumPorts", string3)) instanceof MibValue) {
            n13 = ((MibValue)serializable).getIntValue();
        }
        if ((serializable = this.mibInfo.getVar("ocModNumTrunks", string3)) instanceof MibValue) {
            n14 = ((MibValue)serializable).getIntValue();
        }
        Object[][] objectArray = null;
        if (n6 > 0 && (objectArray = this.getSpecificModuleMetaInfo(n12)) != null) {
            String string4 = null;
            string4 = numberOfIndexes == 1 ? "." + n2 : "." + n2 + "." + n3;
            n11 = this.decodeInformation(n, n6, string4, objectArray);
            if (n11 < n6 && RAS.isEnabled(19, 28)) {
                RAS.trace(19, 28, this, string2, "Some information was not decoded in the specific module information. Missing " + (n6 - n11) + " bytes.");
            }
        }
        n += n6;
        int n15 = 0;
        String string5 = string3;
        if (n13 > 0 && n8 > 0) {
            objectArray = this.getSpecificPortMetaInfo(n12);
        }
        while (n15 < n13) {
            if (RAS.isEnabled(19, 28)) {
                RAS.trace(19, 28, this, string2, "----- PORT INFORMATION -----");
                RAS.trace(19, 28, this, string2, "portSlotIndex -> " + n2);
                RAS.trace(19, 28, this, string2, "portSubSlotIndex -> " + n3);
                RAS.trace(19, 28, this, string2, "portIndex -> " + (n15 + 1));
            }
            string3 = string5;
            n11 = this.decodeInformation(n, n7, string3 = String.valueOf(string3) + "." + (n15 + 1), genericPortInformation);
            if (n11 < n7 && RAS.isEnabled(19, 28)) {
                RAS.trace(19, 28, this, string2, "Some information was not decoded in the generic port information. Missing " + (n7 - n11) + " bytes.");
            }
            n += n7;
            if (objectArray != null) {
                string = null;
                string = numberOfIndexes == 2 ? "." + n2 + "." + (n15 + 1) : "." + n2 + "." + n3 + "." + (n15 + 1);
                n11 = this.decodeInformation(n, n8, string, objectArray);
                if (n11 < n8 && RAS.isEnabled(19, 28)) {
                    RAS.trace(19, 28, this, string2, "Some information was not decoded in the specific port information. Missing " + (n8 - n11) + " bytes.");
                }
            }
            n += n8;
            ++n15;
        }
        n15 = 0;
        string5 = string3 = "." + n2;
        if (n14 > 0 && n10 > 0) {
            objectArray = this.getSpecificTrunkMetaInfo(n12);
        }
        while (n15 < n14) {
            if (RAS.isEnabled(19, 28)) {
                RAS.trace(19, 28, this, string2, "----- TRUNK INFORMATION -----");
                RAS.trace(19, 28, this, string2, "trunkSlotIndex -> " + n2);
                RAS.trace(19, 28, this, string2, "trunkIndex -> " + (n15 + 1));
            }
            string3 = string5;
            string3 = String.valueOf(string3) + "." + (n15 + 1);
            n11 += this.decodeInformation(n, n9, string3, genericTrunkInformation);
            n += n9;
            if (n11 < n9 && RAS.isEnabled(19, 28)) {
                RAS.trace(19, 28, this, string2, "Some information was not decoded in the generic trunk information. Missing " + (n7 - n11) + " bytes.");
            }
            if (objectArray != null) {
                string = null;
                string = numberOfIndexes == 2 ? "." + n2 + "." + (n15 + 1) : "." + n2 + "." + n3 + "." + (n15 + 1);
                n11 = this.decodeInformation(n, n10, string, objectArray);
                if (n11 < n10 && RAS.isEnabled(19, 28)) {
                    RAS.trace(19, 28, this, string2, "Some information was not decoded in the trunk specific information. Missing " + (n10 - n11) + " bytes.");
                }
            }
            n += n10;
            ++n15;
        }
    }

    private final void decodeV2Entry(int n, int n2) throws DecoderException {
        int n3;
        int n4;
        int n5;
        int n6;
        if ((n6 = this.values[n++] & 0xFF) != 2) {
            throw new DecoderException("Structure version mismatch. Expected version 2 entry and found version " + n6 + " at pos. " + (n - 1));
        }
        if ((n5 = this.values[n++] & 0xFF) != 8) {
            throw new DecoderException("Expected maximum of 8 version 1 entries and found " + n5 + " at pos. " + (n - 1));
        }
        if ((n4 = this.values[n++] & 0xFF) > n5) {
            throw new DecoderException("Number of version 1 entries exceeds maximum number. Found number is " + n4 + ". Maximum is " + n5 + " at pos. " + (n - 1));
        }
        if ((n3 = this.values[n++] & 0xFF) != 0) {
            throw new DecoderException("Reserved octet different from 0x00. Found " + n3 + " at pos. " + (n - 1));
        }
        int n7 = 20;
        int n8 = n;
        int n9 = 0;
        while (n9 < n4) {
            int n10;
            int n11;
            int n12;
            if ((n12 = (n11 = this.values[n++] & 0xFF) << 8 | (n10 = this.values[n++] & 0xFF) & 0xFF) == 0) continue;
            int n13 = (n - n8) / 2;
            this.decodeV1Entry(n7, n2, n13);
            n7 += n12;
            ++n9;
        }
    }

    public final boolean decode(byte[] byArray, int n) {
        String string = "decode";
        if (byArray == null) {
            return false;
        }
        if (byArray.length == 0) {
            return false;
        }
        if (RAS.isEnabled(19, 28)) {
            RAS.enter(19, 28, this, string);
        }
        boolean bl = true;
        this.values = byArray;
        int n2 = this.values[0] & 0xFF;
        try {
            switch (n2) {
                case 1: {
                    this.decodeV1Entry(0, n, 1);
                    break;
                }
                case 2: {
                    this.decodeV2Entry(0, n);
                    break;
                }
                default: {
                    throw new DecoderException("Unsupported version of MST entry. Found version is " + n2 + " at pos. 0");
                }
            }
        }
        catch (Exception exception) {
            bl = false;
            RAS.logException(19, 28, this, string, exception);
        }
        this.values = null;
        if (RAS.isEnabled(19, 28)) {
            RAS.exit(19, 28, this, string);
        }
        return true;
    }

    static {
        genericModuleInformation = new Object[][]{{"modType", "1.3.6.1.4.1.49.2.3.1.4.6.1.3", INT_TYPE}, {"modClass", "1.3.6.1.4.1.49.2.3.1.4.6.1.4", INT_TYPE}, {"modDescr", "1.3.6.1.4.1.49.2.3.1.4.6.1.5", STR_TYPE}, {"modVersion", "1.3.6.1.4.1.49.2.3.1.4.6.1.6", STR_TYPE}, {"modNetwork", "1.3.6.1.4.1.49.2.3.1.4.6.1.11", INT_TYPE}, {"modNetworkType", "1.3.6.1.4.1.49.2.3.1.4.6.1.12", INT_TYPE}, {"modStatus", "1.3.6.1.4.1.49.2.3.1.4.6.1.13", INT_TYPE}, {"modNumPorts", "1.3.6.1.4.1.49.2.3.1.4.6.1.14", INT_TYPE}, {"modNumTrunks", "1.3.6.1.4.1.49.2.3.1.4.6.1.15", INT_TYPE}, {"modNumOccupiedSlots", "1.3.6.1.4.1.49.2.3.1.4.6.1.17", INT_TYPE}, {"modSlotOffset", "1.3.6.1.4.1.49.2.3.1.4.6.1.18", INT_TYPE}};
        genericPortInformation = new Object[][]{{"portType", "1.3.6.1.4.1.49.2.3.1.4.11.1.4", INT_TYPE}, {"portConnector", "1.3.6.1.4.1.49.2.3.1.4.11.1.5", INT_TYPE}, {"portStatus", "1.3.6.1.4.1.49.2.3.1.4.11.1.6", INT_TYPE}, {"portAdminState", "1.3.6.1.4.1.49.2.3.1.4.11.1.7", INT_TYPE}, {"portNetwork", "1.3.6.1.4.1.49.2.3.1.4.11.1.8", INT_TYPE}, {"portNetworkType", "1.3.6.1.4.1.49.2.3.1.4.11.1.9", INT_TYPE}, {"portAlertMode", "1.3.6.1.4.1.49.2.3.1.4.11.1.10", INT_TYPE}};
        genericTrunkInformation = new Object[][]{{"trunkType", "1.3.6.1.4.1.49.2.3.1.4.3.1.3", INT_TYPE}, {"trunkConnector", "1.3.6.1.4.1.49.2.3.1.4.3.1.4", INT_TYPE}, {"trunkStatus", "1.3.6.1.4.1.49.2.3.1.4.3.1.5", INT_TYPE}, {"trunkAdminState", "1.3.6.1.4.1.49.2.3.1.4.3.1.6", INT_TYPE}, {"trunkWrapState", "1.3.6.1.4.1.49.2.3.1.4.3.1.7", INT_TYPE}, {"trunkNeighbor", "1.3.6.1.4.1.49.2.3.1.4.3.1.8", INT_TYPE}, {"trunkNetwork", "1.3.6.1.4.1.49.2.3.1.4.3.1.9", INT_TYPE}, {"trunkNetworkType", "1.3.6.1.4.1.49.2.3.1.4.3.1.10", INT_TYPE}};
        specificModuleT44Information = new Object[][]{{"tMACModBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.3", STR_TYPE}, {"tMACModIpAddress", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.4", IP_TYPE}, {"tMACModSubnetMask", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.5", IP_TYPE}, {"tMACModDefaultGateway", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.6", IP_TYPE}, {"tMACModStationAddr", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.7", MAC_TYPE}, {"tMACModInterfaceMode", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.8", INT_TYPE}, {"tMACModTRAdapterStatus", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.9", INT_TYPE}, {"tMACModTRMacAddrType", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.10", INT_TYPE}, {"tMACModTRLocAdminAddr", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.11", MAC_TYPE}, {"tMACModTRChipFlashVer", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.12", STR_TYPE}, {"tMACModTRChipBufStatus", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.13", INT_TYPE}, {"tMACModTREarlyTokenRel", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.14", INT_TYPE}, {"tMACModTRMonitorConten", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.15", INT_TYPE}, {"tMACModTRInternalWrap", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.16", INT_TYPE}, {"tMACModTRExternalWrap", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.17", INT_TYPE}, {"tMACModIfIndex", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.18", INT_TYPE}, {"tMACModRMONStatsMode", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.19", INT_TYPE}, {"tMACModDot5StatsMode", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.20", INT_TYPE}, {"tMACModRMONHostStatsMode", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.21", INT_TYPE}, {"tMACModRMONRingStationStatsMode", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.22", INT_TYPE}, {"tMACModRMONMLStatsMode", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.23", INT_TYPE}, {"tMACModRMONPStatsMode", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.24", INT_TYPE}, {"tMACModRMONSrcRoutingStatsMode", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.25", INT_TYPE}, {"tMACModRMONSurrogateStatsMode", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.26", INT_TYPE}, {"tMACModARPResolveMethod", "1.3.6.1.4.1.49.2.3.1.4.4.44.6.1.27", INT_TYPE}};
        specificModuleT45Information = new Object[][]{{"eMACModBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.45.6.1.3", STR_TYPE}, {"eMACModIpAddress", "1.3.6.1.4.1.49.2.3.1.4.4.45.6.1.4", IP_TYPE}, {"eMACModSubnetMask", "1.3.6.1.4.1.49.2.3.1.4.4.45.6.1.5", IP_TYPE}, {"eMACModDefaultGateway", "1.3.6.1.4.1.49.2.3.1.4.4.45.6.1.6", IP_TYPE}, {"eMACModStationAddr", "1.3.6.1.4.1.49.2.3.1.4.4.45.6.1.7", MAC_TYPE}, {"eMACModInterfaceMode", "1.3.6.1.4.1.49.2.3.1.4.4.45.6.1.8", INT_TYPE}, {"eMACModRMONHostStatsMode", "1.3.6.1.4.1.49.2.3.1.4.4.45.6.1.9", INT_TYPE}, {"eMACModIfIndex", "1.3.6.1.4.1.49.2.3.1.4.4.45.6.1.10", INT_TYPE}, {"eMACModRMONProbeMode", "1.3.6.1.4.1.49.2.3.1.4.4.45.6.1.11", INT_TYPE}};
        specificModuleT49Information = new Object[][]{{"hTMACModBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.3", STR_TYPE}, {"hTMACModIpAddress", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.4", IP_TYPE}, {"hTMACModSubnetMask", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.5", IP_TYPE}, {"hTMACModDefaultGateway", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.6", IP_TYPE}, {"hTMACModStationAddr", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.7", MAC_TYPE}, {"hTMACModInterfaceMode", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.8", INT_TYPE}, {"hTMACModTRAdapterStatus", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.9", INT_TYPE}, {"hTMACModTRMacAddrType", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.10", INT_TYPE}, {"hTMACModTRLocalAdminAddr", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.11", MAC_TYPE}, {"hTMACModTRChipFlashVer", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.12", STR_TYPE}, {"hTMACModTRChipBufStatus", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.13", INT_TYPE}, {"hTMACModTREarlyTokenRel", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.14", INT_TYPE}, {"hTMACModTRMonitorConten", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.15", INT_TYPE}, {"hTMACModTRInternalWrap", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.16", INT_TYPE}, {"hTMACModTRExternalWrap", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.17", INT_TYPE}, {"hTMACModIfIndex", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.18", INT_TYPE}, {"hTMACModDot5StatsMode", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.19", INT_TYPE}, {"hTMACModRMONSurrogateStatsMode", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.20", INT_TYPE}, {"hTMACModARPResolveMethod", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.21", INT_TYPE}, {"hTMACModProbeIpAddress", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.22", IP_TYPE}, {"hTMACModProbeSubnetMask", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.23", IP_TYPE}, {"hTMACModProbeDefaultGateway", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.24", IP_TYPE}, {"hTMACModRAMCfg", "1.3.6.1.4.1.49.2.3.1.4.4.49.6.1.25", INT_TYPE}};
        specificModuleT63Information = new Object[][]{{"t50TCModOEMType", "1.3.6.1.4.1.49.2.3.1.4.4.63.1.1.2", INT_TYPE}, {"t50TCModBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.63.1.1.3", STR_TYPE}, {"t50TCModOEMVersion", "1.3.6.1.4.1.49.2.3.1.4.4.63.1.1.4", STR_TYPE}, {"t50TCModOEMBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.63.1.1.5", STR_TYPE}, {"t50TCModCapabilities", "1.3.6.1.4.1.49.2.3.1.4.4.63.1.1.6", STR_TYPE}, {"t50TCModPortCount", "1.3.6.1.4.1.49.2.3.1.4.4.63.1.1.7", INT_TYPE}, {"t50TCModRingSpeed", "1.3.6.1.4.1.49.2.3.1.4.4.63.1.1.8", INT_TYPE}, {"t50TCModNetworkStatus", "1.3.6.1.4.1.49.2.3.1.4.4.63.1.1.9", INT_TYPE}};
        specificPortT63Information = new Object[][]{{"t50TCPortIpAddress", "1.3.6.1.4.1.49.2.3.1.4.4.63.2.1.3", IP_TYPE}, {"t50TCPortStationAddress", "1.3.6.1.4.1.49.2.3.1.4.4.63.2.1.4", MAC_TYPE}, {"t50TCPortCapabilities", "1.3.6.1.4.1.49.2.3.1.4.4.63.2.1.5", STR_TYPE}};
        specificModuleT64Information = new Object[][]{{"e50ECModOEMType", "1.3.6.1.4.1.49.2.3.1.4.4.64.1.1.2", INT_TYPE}, {"e50ECModBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.64.1.1.3", STR_TYPE}, {"e50ECModOEMVersion", "1.3.6.1.4.1.49.2.3.1.4.4.64.1.1.4", STR_TYPE}, {"e50ECModOEMBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.64.1.1.5", STR_TYPE}, {"e50ECModCapabilities", "1.3.6.1.4.1.49.2.3.1.4.4.64.1.1.6", STR_TYPE}, {"e50ECModOEMFrontPortCount", "1.3.6.1.4.1.49.2.3.1.4.4.64.1.1.7", INT_TYPE}};
        specificPortT64Information = new Object[][]{{"e50TCPortIpAddress", "1.3.6.1.4.1.49.2.3.1.4.4.64.2.1.3", IP_TYPE}, {"e50TCPortStationAddress", "1.3.6.1.4.1.49.2.3.1.4.4.64.2.1.4", MAC_TYPE}, {"e50TCPortCapabilities", "1.3.6.1.4.1.49.2.3.1.4.4.64.2.1.5", STR_TYPE}};
        specificModuleT73Information = new Object[][]{{"e04MMODModBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.73.6.1.3", STR_TYPE}, {"e04MMODModDipNVram", "1.3.6.1.4.1.49.2.3.1.4.4.73.6.1.4", INT_TYPE}, {"e04MMODModNumBays", "1.3.6.1.4.1.49.2.3.1.4.4.73.6.1.5", INT_TYPE}};
        specificPortT73Information = new Object[][]{{"e04MMODPortBayIndex", "1.3.6.1.4.1.49.2.3.1.4.4.73.2.1.3", INT_TYPE}, {"e04MMODPortBayPortIndex", "1.3.6.1.4.1.49.2.3.1.4.4.73.2.1.4", INT_TYPE}, {"e04MMODPortBayType", "1.3.6.1.4.1.49.2.3.1.4.4.73.2.1.5", INT_TYPE}, {"e04MMODPortAdminState", "1.3.6.1.4.1.49.2.3.1.4.4.73.2.1.6", INT_TYPE}, {"e04MMODPortBuddySlot", "1.3.6.1.4.1.49.2.3.1.4.4.73.2.1.7", INT_TYPE}, {"e04MMODPortBuddyPort", "1.3.6.1.4.1.49.2.3.1.4.4.73.2.1.8", INT_TYPE}};
        specificModuleT97Information = new Object[][]{{"hEEMACModBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.97.6.1.3", STR_TYPE}, {"hEEMACModDlmDownloadMode", "1.3.6.1.4.1.49.2.3.1.4.4.97.6.1.4", INT_TYPE}, {"hEEMACModRAMCfg", "1.3.6.1.4.1.49.2.3.1.4.4.97.6.1.5", INT_TYPE}};
        specificPortT97Information = new Object[][]{{"hEEMACPortIpAddress", "1.3.6.1.4.1.49.2.3.1.4.4.97.11.1.4", IP_TYPE}, {"hEEMACPortSubnetMask", "1.3.6.1.4.1.49.2.3.1.4.4.97.11.1.5", IP_TYPE}, {"hEEMACPortDefaultGateway", "1.3.6.1.4.1.49.2.3.1.4.4.97.11.1.6", IP_TYPE}, {"hEEMACPortStationAddr", "1.3.6.1.4.1.49.2.3.1.4.4.97.11.1.7", MAC_TYPE}, {"hEEMACPortInterfaceMode", "1.3.6.1.4.1.49.2.3.1.4.4.97.11.1.8", INT_TYPE}, {"hEEMACPortIfIndex", "1.3.6.1.4.1.49.2.3.1.4.4.97.11.1.9", INT_TYPE}};
        specificModuleT123Information = new Object[][]{{"a2MB155ModBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.123.6.1.3", STR_TYPE}, {"a2MB155ModNumBays", "1.3.6.1.4.1.49.2.3.1.4.4.123.6.1.4", INT_TYPE}};
        specificPortT123Information = new Object[][]{{"a2MB155PortBayIndex", "1.3.6.1.4.1.49.2.3.1.4.4.123.2.1.3", INT_TYPE}, {"a2MB155PortBayPortIndex", "1.3.6.1.4.1.49.2.3.1.4.4.123.2.1.4", INT_TYPE}, {"a2MB155PortBayType", "1.3.6.1.4.1.49.2.3.1.4.4.123.2.1.5", INT_TYPE}, {"a2MB155PortSpeed", "1.3.6.1.4.1.49.2.3.1.4.4.123.2.1.6", INT_TYPE}};
        specificModuleT138Information = new Object[][]{{"aCARModPortNum", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.3", STR_TYPE}, {"aCARModNumSwitchPorts", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.4", INT_TYPE}, {"aCARModOEMType", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.5", INT_TYPE}, {"aCARModEng1Type", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.6", INT_TYPE}, {"aCARModEng1Description", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.7", STR_TYPE}, {"aCARModEng1ModelNum", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.8", STR_TYPE}, {"aCARModEng1PartNum", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.9", STR_TYPE}, {"aCARModEng1Vendor", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.10", INT_TYPE}, {"aCARModEng1Status", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.11", INT_TYPE}, {"aCARModEng1OPSWVersion", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.12", STR_TYPE}, {"aCARModEng1BootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.13", STR_TYPE}, {"aCARModEng1Capabilities", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.14", INT_TYPE}, {"aCARModEng1NumBackPorts", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.15", INT_TYPE}, {"aCARModEng1NumFrontPorts", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.16", INT_TYPE}, {"aCARModEng1NumUtopiaPorts", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.17", INT_TYPE}, {"aCARModEng1IpAddr", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.18", IP_TYPE}, {"aCARModEng1SubnetMask", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.19", IP_TYPE}, {"aCARModEng1IpDefGtwy", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.20", IP_TYPE}, {"aCARModEng2Type", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.21", INT_TYPE}, {"aCARModEng2Description", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.22", STR_TYPE}, {"aCARModEng2ModelNum", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.23", STR_TYPE}, {"aCARModEng2PartNum", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.24", STR_TYPE}, {"aCARModEng2Vendor", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.25", INT_TYPE}, {"aCARModEng2Status", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.26", INT_TYPE}, {"aCARModEng2OPSWVersion", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.27", STR_TYPE}, {"aCARModEng2BootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.28", STR_TYPE}, {"aCARModEng2Capabilities", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.29", INT_TYPE}, {"aCARModEng2NumBackPorts", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.30", INT_TYPE}, {"aCARModEng2NumFrontPorts", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.31", INT_TYPE}, {"aCARModEng2NumUtopiaPorts", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.32", INT_TYPE}, {"aCARModEng2IpAddr", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.33", IP_TYPE}, {"aCARModEng2SubnetMask", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.34", IP_TYPE}, {"aCARModEng2IpDefGtwy", "1.3.6.1.4.1.49.2.3.1.4.4.138.6.1.35", IP_TYPE}};
        specificPortT138Information = new Object[][]{{"aCARPortBayIndex", "1.3.6.1.4.1.49.2.3.1.4.4.138.2.1.3", INT_TYPE}, {"aCARPortBayType", "1.3.6.1.4.1.49.2.3.1.4.4.138.2.1.4", INT_TYPE}, {"aCARPortSpeed", "1.3.6.1.4.1.49.2.3.1.4.4.138.2.1.5", INT_TYPE}, {"aCARPortUFC1Slot2", "1.3.6.1.4.1.49.2.3.1.4.4.138.2.1.6", INT_TYPE}, {"aCARPortUFC2Slot2", "1.3.6.1.4.1.49.2.3.1.4.4.138.2.1.7", INT_TYPE}, {"aCARPortUFC1Slot3", "1.3.6.1.4.1.49.2.3.1.4.4.138.2.1.8", INT_TYPE}, {"aCARPortUFC2Slot3", "1.3.6.1.4.1.49.2.3.1.4.4.138.2.1.9", INT_TYPE}};
        specificModuleT153Information = new Object[][]{{"a2MB1553PModBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.153.6.1.3", STR_TYPE}, {"a2MB1553PModNumBays", "1.3.6.1.4.1.49.2.3.1.4.4.153.6.1.4", INT_TYPE}};
        specificPortT153Information = new Object[][]{{"a2MB1553PPortBayIndex", "1.3.6.1.4.1.49.2.3.1.4.4.153.2.1.3", INT_TYPE}, {"a2MB1553PPortBayPortIndex", "1.3.6.1.4.1.49.2.3.1.4.4.153.2.1.4", INT_TYPE}, {"a2MB1553PPortBayType", "1.3.6.1.4.1.49.2.3.1.4.4.153.2.1.5", INT_TYPE}, {"a2MB1553PPortSpeed", "1.3.6.1.4.1.49.2.3.1.4.4.153.2.1.6", INT_TYPE}};
        specificModuleT164Information = new Object[][]{{"a4p115CUSTOMModBootVersion", "1.3.6.1.4.1.49.2.3.1.4.4.164.6.1.3", STR_TYPE}, {"a4p115CUSTOMModNumBays", "1.3.6.1.4.1.49.2.3.1.4.4.164.6.1.4", INT_TYPE}};
        specificPortT164Information = new Object[][]{{"a4p115CUSTOMPortBayIndex", "1.3.6.1.4.1.49.2.3.1.4.4.164.2.1.3", INT_TYPE}, {"a4p115CUSTOMPortBayPortIndex", "1.3.6.1.4.1.49.2.3.1.4.4.164.2.1.4", INT_TYPE}, {"a4p115CUSTOMPortBayType", "1.3.6.1.4.1.49.2.3.1.4.4.164.2.1.5", INT_TYPE}, {"a4p115CUSTOMPortSpeed", "1.3.6.1.4.1.49.2.3.1.4.4.164.2.1.6", INT_TYPE}};
    }
}

